IF NOT EXISTS( select * from sys.columns where Name = N'Counter' and Object_ID = Object_ID(N'TimeSlotHit'))
BEGIN
ALTER TABLE TimeSlotHit ADD
	[Counter] int NOT NULL CONSTRAINT DF_TimeSlotHit_Counter DEFAULT 0;
--When creating Counter field, the existance of a hit implies a counter = 1	
--Using EXEC to prevent error with Invalid Column
END
GO

--Should check before doing...
UPDATE TimeSlotHit SET [Counter] = 1;

IF NOT EXISTS( select * from sys.columns where Name = N'MaxCounter' and Object_ID = Object_ID(N'TimeSlot'))
BEGIN
ALTER TABLE TimeSlot ADD
	MaxCounter int NOT NULL CONSTRAINT DF_TimeSlot_MaxCounter DEFAULT 1
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'ResetOnLevelChange' and Object_ID = Object_ID(N'TimeSlot'))
BEGIN
ALTER TABLE TimeSlot ADD
	ResetOnLevelChange bit NOT NULL CONSTRAINT DF_TimeSlot_ResetOnLevelChange DEFAULT 0
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'LevelChanged' and Object_ID = Object_ID(N'Historic'))
BEGIN
ALTER TABLE Historic ADD
	LevelChanged bit NOT NULL CONSTRAINT DF_Historic_LevelChanged DEFAULT 0
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'RestrictionOverride' and Object_ID = Object_ID(N'Respondent'))
BEGIN
ALTER TABLE Respondent ADD
	RestrictionOverride bit NOT NULL CONSTRAINT DF_Respondent_RestrictionOverride DEFAULT 0
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'RestrictionOverride' and Object_ID = Object_ID(N'Rules'))
BEGIN
ALTER TABLE Rules ADD
	RestrictionOverride bit NOT NULL CONSTRAINT DF_Rules_RestrictionOverride DEFAULT 0
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'RestrictionOverride' and Object_ID = Object_ID(N'ExtendedRules'))
BEGIN
ALTER TABLE ExtendedRules ADD
	RestrictionOverride bit NOT NULL CONSTRAINT DF_ExtendedRules_RestrictionOverride DEFAULT 0
END
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TimeSlotCounter]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[TimeSlotCounter](
	[TimeSlotCounterId] [int] NOT NULL IDENTITY (1, 1),
	[TslNumber] [int] NOT NULL,
	[RespondentLevel] [int] NOT NULL,
	[MaxCounter] [int] NOT NULL,
 CONSTRAINT [PK_TimeSlotCounter] PRIMARY KEY CLUSTERED 
(
	[TimeSlotCounterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

/****** Object:  Index [IX_TimeSlotCounters]    Script Date: 10/13/2011 09:29:41 ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TimeSlotCounter]') AND name = N'IX_TimeSlotCounter')
CREATE UNIQUE NONCLUSTERED INDEX [IX_TimeSlotCounter] ON [dbo].[TimeSlotCounter] 
(
	[TslNumber] ASC,
	[RespondentLevel] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_TimeSlotCounter_MaxCounter]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[TimeSlotCounter] ADD  CONSTRAINT [DF_TimeSlotCounter_MaxCounter]  DEFAULT ((0)) FOR [MaxCounter]
END

GO

IF NOT EXISTS( select * from sys.columns where Name = N'IntLevel' and Object_ID = Object_ID(N'Respondent'))
BEGIN
ALTER TABLE Respondent ADD
	IntLevel int NOT NULL CONSTRAINT DF_Respondent_IntLevel DEFAULT 0
END
GO

IF NOT EXISTS( select * from sys.columns where Name = N'OrderKey' and Object_ID = Object_ID(N'BufferNew'))
BEGIN
ALTER TABLE dbo.BufferNew ADD
	OrderKey int NOT NULL IDENTITY (1, 1)
END
GO



